function du=mq(y)
% convert monthly series to quarterly one
% if only one month available at the end of series, get rid of the last
% month

du=[];
if size(y,1)==1
    y=y';
end
if length(y)/3==int64(length(y)/3)
    for i=1:3:size(y,1)
        du=[du ; sum(y(i:i+2,:))/3];
    end;
else
    for jj=1:2
        if ((length(y)-jj)/3)==int64((length(y)-jj)/3)
            for i=1:3:size(y,1)
                if i<size(y,1)-jj
                    du=[du ; sum(y(i:i+2,:))/3];
                else
                    % use only the data available to infer the avg over the
                    % last period
                    if jj==2
                  %      'I used only two last months'
                    du=[du ; sum(y(i:i+jj-1,:))/jj];
                    end
                end;

            end
        end
    end
end